
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Nov 29 19:51:53 2007
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_FLOW_MAIN.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/* disabling pc lint warning regarding to constant condition :
   'Constant value Boolean' */
/*lint --e{506} */

/***** Include Files ******/
#include "CRYS.h"

#include "CRYS_ATP_TST_Defines.h"
#include "CRYS_ATP_TST_FLOW_Acceptance.h"
#include "CRYS_ATP_TST_AESFLOW_Acceptance.h"
#include "CRYS_ATP_TST_HASHFLOW_Acceptance.h"
#include "CRYS_ATP_TST_DESFLOW_Acceptance.h"
#include "CRYS_ATP_TST_RC4FLOW_Acceptance.h"
#include "CRYS_ATP_TST_HMACFLOW_Acceptance.h"

#include "CRYS_ATP_TST_UTIL_Funcs.h"

#include <stdio.h>
#include "DX_VOS_Mem.h"

#if TST_USE_FLOW_DATA /*In case no test vectors are selected - code disabled*/


/******** Defines ********/
/******** Enums **********/
/******** Typedefs *********/
/******** Global Data ********/
/***** Private function prototype ******/
CRYSError_t CRYS_ATP_TST_FLOW_STATIC_Acceptance_ALL_TESTS(void);
CRYSError_t CRYS_ATP_TST_FLOW_DYNAMIC_Acceptance_ALL_TESTS(void);
CRYSError_t CRYS_ATP_TST_FLOW_Acceptance_ALL_TESTS(void);


/******** Public Functions *****/
void CRYS_ATP_TST_FLOW_main(void)
{
  DxUint8_t  Var;

  do
   {
	   do
	   {
	           ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n\n\n--[ FLOW tests Menu ]----------------------------------"));
	           
	           
	           ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [1] - Acceptance of static flow operations"));
	           ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [2] - Acceptance of static flow operations with additional engines"));			   
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [3] - Acceptance of static cyclic flow operations"));			   	           
               
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [4] - Acceptance of static flow operations in parallel way"));
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [5] - Acceptance of static flow operations in sequentially way"));
               
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [6] - Acceptance of dynamic flow operations"));
	           ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [7] - Acceptance of dynamic flow operations with add buffers"));
	           ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [8] - Acceptance of dynamic flow operations with additional engines"));			   
               
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [9] - Acceptance of dynamic flow operations in parallel way"));
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [A] - Acceptance of dynamic flow operations in sequentially way"));
	           
	           ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [T] - ALL FLOW Acceptance tests                      "));
			   ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [Z] - End of tests return to prev menu			   "));
	           ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n-----------------------------------------------------\n\n"));
	           scanf("\n%c",&Var);
	           ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n Test = %c\n",Var));
	           if (Var<='Z')
	                    break;
	           else
	           {
	                 ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n Error[%d]  Please select '1'-'XX'\n\n",Var));
	           }

	    }while(1);


	    switch(Var)
	    {
	        case '1':
				    CRYS_ATP_TST_FLOW_STATIC_Acceptance();
				    break;
	        
            case '2':
	                CRYS_ATP_TST_FLOW_STATIC_Acceptance_WithAdditionalEngines();
	                break;
            case '3':
	                CRYS_ATP_TST_FLOW_STATIC_Cyclic_Acceptance();
	                break;	                	                	                
	                
	                
			case '4':
					CRYS_ATP_TST_FLOW_PARALLEL_STATIC_Acceptance();
					break;
					
	        case '5':
	                CRYS_ATP_TST_FLOW_SEQUENTIALLY_STATIC_Acceptance();	                               	               
	                break;
	                
	        case '6':
				    CRYS_ATP_TST_FLOW_DYNAMIC_Acceptance();
				    break;
	        case '7':
	                CRYS_ATP_TST_FLOW_DYNAMIC_AddBuffers_Acceptance();
	                break;
	        case '8':
	                CRYS_ATP_TST_FLOW_DYNAMIC_Acceptance_WithAdditionalEngines();
	                break;	        
                    
	        case '9':
	                CRYS_ATP_TST_FLOW_PARALLEL_DYNAMIC_Acceptance();
	                break;	 
	                
            case 'A':	                
	                CRYS_ATP_TST_FLOW_SEQUENTIALLY_DYNAMIC_Acceptance();	                               	               
	                break;
	                 
		  	case 'T':
		  			CRYS_ATP_TST_FLOW_Acceptance_ALL_TESTS();
				    break;
	       	case 'Z':
	                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n End of FLOW tests \n"));
	                break ;

	       	default:
	              ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n* Error in test selection [%c]\n",Var));
	    }
	       if(Var =='Z')
	       break;
     }while (1);
}


/******** Private Functions **********/

/***************************
 * Function Name:
 * 	CRYS_ATP_TST_FLOW_Acceptance_ALL_TESTS
 *
 * Inputs:
 * 	none
 *
 * Outputs:
 * 	CRYSError_t - Function error return
 *
 * Description:
 * This function runs all of the FLOW Acceptance tests
 *
 **************************/
CRYSError_t CRYS_ATP_TST_FLOW_Acceptance_ALL_TESTS(void)
{
    CRYSError_t TST_ATP_FLOW_Error = TESTPASS , TST_Status = TESTPASS;
    
    TST_Status = CRYS_ATP_TST_FLOW_STATIC_Acceptance();
    TST_ATP_FLOW_Error = TST_ATP_FLOW_Error+TST_Status;
    
    #if CRYS_ATP_TST_EXIT_SYS_TST_ON_ERROR
    if (TST_ATP_FLOW_Error != TESTPASS)
        return 	TST_ATP_FLOW_Error;
    #endif
    
    CRYS_ATP_TST_FLOW_STATIC_Acceptance_WithAdditionalEngines();
    TST_ATP_FLOW_Error = TST_ATP_FLOW_Error+TST_Status;
    
    #if CRYS_ATP_TST_EXIT_SYS_TST_ON_ERROR
    if (TST_ATP_FLOW_Error != TESTPASS)
        return 	TST_ATP_FLOW_Error;
    #endif
	        
    TST_Status = CRYS_ATP_TST_FLOW_STATIC_Cyclic_Acceptance();
    TST_ATP_FLOW_Error = TST_ATP_FLOW_Error+TST_Status;
    
    #if CRYS_ATP_TST_EXIT_SYS_TST_ON_ERROR
    if (TST_ATP_FLOW_Error != TESTPASS)
        return 	TST_ATP_FLOW_Error;
    #endif
    
    TST_Status = CRYS_ATP_TST_FLOW_PARALLEL_STATIC_Acceptance();
    TST_ATP_FLOW_Error = TST_ATP_FLOW_Error+TST_Status;
    
    #if CRYS_ATP_TST_EXIT_SYS_TST_ON_ERROR
    if (TST_ATP_FLOW_Error != TESTPASS)
        return 	TST_ATP_FLOW_Error;
    #endif

    TST_Status = CRYS_ATP_TST_FLOW_SEQUENTIALLY_STATIC_Acceptance();	                               	               
    TST_ATP_FLOW_Error = TST_ATP_FLOW_Error+TST_Status;
    
    #if CRYS_ATP_TST_EXIT_SYS_TST_ON_ERROR
    if (TST_ATP_FLOW_Error != TESTPASS)
        return 	TST_ATP_FLOW_Error;
    #endif
    
    TST_Status = CRYS_ATP_TST_FLOW_DYNAMIC_Acceptance();
    TST_ATP_FLOW_Error = TST_ATP_FLOW_Error+TST_Status;
    
    #if CRYS_ATP_TST_EXIT_SYS_TST_ON_ERROR
    if (TST_ATP_FLOW_Error != TESTPASS)
        return 	TST_ATP_FLOW_Error;
    #endif
    
    TST_Status = CRYS_ATP_TST_FLOW_DYNAMIC_AddBuffers_Acceptance();
    TST_ATP_FLOW_Error = TST_ATP_FLOW_Error+TST_Status;
    
    #if CRYS_ATP_TST_EXIT_SYS_TST_ON_ERROR
    if (TST_ATP_FLOW_Error != TESTPASS)
        return 	TST_ATP_FLOW_Error;
    #endif

    TST_Status = CRYS_ATP_TST_FLOW_DYNAMIC_Acceptance_WithAdditionalEngines();
    TST_ATP_FLOW_Error = TST_ATP_FLOW_Error+TST_Status;
    
    #if CRYS_ATP_TST_EXIT_SYS_TST_ON_ERROR
    if (TST_ATP_FLOW_Error != TESTPASS)
        return 	TST_ATP_FLOW_Error;
    #endif

    TST_Status = CRYS_ATP_TST_FLOW_PARALLEL_DYNAMIC_Acceptance();
    TST_ATP_FLOW_Error = TST_ATP_FLOW_Error+TST_Status;
    
    #if CRYS_ATP_TST_EXIT_SYS_TST_ON_ERROR
    if (TST_ATP_FLOW_Error != TESTPASS)
        return 	TST_ATP_FLOW_Error;
    #endif

    TST_Status = CRYS_ATP_TST_FLOW_SEQUENTIALLY_DYNAMIC_Acceptance();	                               	               
    TST_ATP_FLOW_Error = TST_ATP_FLOW_Error+TST_Status;
    
    #if CRYS_ATP_TST_EXIT_SYS_TST_ON_ERROR
    if (TST_ATP_FLOW_Error != TESTPASS)
        return 	TST_ATP_FLOW_Error;
    #endif
    
    
    /*Check if all tests pass*/
	if (TST_ATP_FLOW_Error != TESTPASS)
	{
		ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
		ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!!!!!!! ONE OR MORE OF THE OTF TESTS FAILED !!!!!!!!!!!!!!!!!!!!\n"));
		ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
	}
	else
	{
		ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n \n**********************\n"));
		ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************\n"));
		ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*** ALL OF THE FLOW Acceptance TESTS PASS   :-)         ***\n"));
		ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************\n"));
		ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************\n"));
	}
	
	return TST_ATP_FLOW_Error;

}

#endif

